package keepoutbot;

import cz.cuni.pogamut.exceptions.PogamutException;
import cz.cuni.pogamut.exceptions.ScriptedAgentException;
import cz.cuni.sposhBot.java.JavaBehaviour;
import cz.cuni.sposhBot.java.SPoshBot;
import cz.cuni.utils.Config;
import java.io.File;

/**
 *  NOTE: Class with agent must be marked also in manifest.mf, otherwise IDE don't know, which file it should run.
 *
 *  WARNING: you need to set the path to the planfile, edit getPlanFile() method!
 */
public class Main extends SPoshBot {
    
    /** Creates a new instance of agent. */
    public Main() throws ScriptedAgentException {
        super();        
    }
    
    protected JavaBehaviour getBehaviour() {
        return new MyBehaviour("MyBehaviour", this.log, this);
    }
    
    protected String getPlanFile() {
        return Config.getProjectsPath()+File.separator+"HonzaBlazek-DM-SPOSH"+File.separator+"src"+File.separator+"keepoutbot"+File.separator+"sposhPlan.lap";
    }
    
    protected void prePrepareAgent()  throws PogamutException {        
        super.prePrepareAgent();
        /* Prepares agent logic to run - like initializing neural networks etc.
        not for establishing communication! */
    }
    
    protected void postPrepareAgent() throws PogamutException {        
        super.postPrepareAgent();
        /* Prepare logic according to information from gathered from startCommunication
        like choosing plan/parameters according to game type. */
        body.initializer.setBotSkillLevel(3);
        ((MyBehaviour)behaviour).traces.botInit();
    }
    
    protected void shutdownAgent() throws PogamutException {        
        super.shutdownAgent();
        /* Clean up after the end of simulation of agent */
    }
    
    public static void main(String[] args) {
    }
}
